;								EJEMPLO 35
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El mdulo conversor ADC. Variando la anchura del pulso en una seal de salida
;
;Los dispositivos PIC16F87X disponen de un convertidor A/D de 10 bits de resolucin y 5 u 8 
;canales de entrada analgica. La tensin de referencia determina la resolucin por bit:
;(Res. = Vref/1024). Con 5 Vref=4.8 mV/Bit; con 2.5 Vref=2.4 mV/Bit
;
;Se propone realizar una modulacin de anchura de pulsos (PWM) mediante el mdulo CCP1 y con
;salida de seal por la lnea RC2/CCP1. Se establece un periodo fijo de 3200uS
;
;El TMR2 trabajando con un preescaler de 1:16 y a una frecuencia de 4 MHz evoluciona cada 16 uS
;
;Un osciloscopio conectado en RC2/CCP1 permitir visualizar las variaciones del ancho de pulso de la seal
;de salida segn la tensin analgica aplicada por RA0/AN0

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Periodo		equ	.200		;Valor para el periodo (3200uS)
Duty_H		equ	0x20
Duty_L		equ	0x21		;Variable para la anchura de pulso

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x05
	
;Programa principal

Inicio	   	clrf	PORTA
			clrf 	PORTC
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	ADCON1		;Puerta A analgica, justificacin izda.
			movlw	b'00111111'
			movwf	TRISA		;RA5-RA0 entradas
			movlw	b'11111011'
			movwf	TRISC		;RC2/CCP1 salida
			bcf		STATUS,RP0	;Selecciona banco 0

;Se activa el ADC y se selecciona el canal RA0/AN0. Frecuencia de trabajo Fosc/32

Loop		clrwdt	
			movlw	b'10000001'
			movwf	ADCON0		;ADC en On, seleciona canal AN0
			bcf		PIR1,ADIF	;Restaura el flag del conversor AD
			nop
			bsf		ADCON0,GO	;Inicia la conversin

ADC_Wait_0	btfss	PIR1,ADIF	;Fin de conversin ??
			goto	ADC_Wait_0	;Todava no		
			movf	ADRESH,w
			movwf	Duty_H		;Registra valor actual para el periodo
			bsf		STATUS,RP0	;Selecciona pgina 1
			rrf		ADRESL,F
			rrf		ADRESL,W
			bcf		STATUS,RP0	;Selecciona pgina 0
			andlw	b'00110000'
			movwf	Duty_L		;Salva parte baja de la conversin
		
;El mdulo CCP1 se configura en modo PWM con salida por RC2/CCP1. Los bits LSB se obtienen
;de la variable Duty_L

			movlw	b'00001100'
			iorwf	Duty_L,F
			movwf	CCP1CON		;Modo PWM para el mdulo CCP1

;El periodo se determina segn el valor de la constante "Periodo". Este se carga sobre el
;registro PR2.

			movlw	Periodo
			bsf		STATUS,RP0	;Selecciona pgina 1
			movwf	PR2
			bcf		STATUS,RP0	;Selecciona pgina 0

;La anchura del pulso o "Duty" se determina segn el valor con que se cargue el registro
;CCPR1L concatenado con los bits 4 y 5 de CCP1CON. Dichos valores se obtiene de las varia-
;bles Duty_H y Duty_L respectivamente.

			movf	Duty_H,W
			movwf	CCPR1L

;Trabajando con un preescaler 1:16 y a una frecuancia de 4MHz, el TMR2 evoluciona cada 16 uS.

			movlw	b'01111100'
			movwf	T2CON		;TMR2 en On
			goto	Loop

			end					;Fin del programa fuente
